<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('re_accounts', 'company')) {
            Schema::table('re_accounts', function (Blueprint $table) {
                $table->string('company')->nullable();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('re_accounts', 'company')) {
            Schema::table('re_accounts', function (Blueprint $table) {
                $table->dropColumn('company');
            });
        }
    }
};
