<?php

namespace Botble\RealEstate\Http\Controllers\Chunk;

use Botble\Base\Facades\BaseHelper;
use Botble\Base\Http\Controllers\BaseController;
use Botble\Media\Chunks\Exceptions\UploadMissingFileException;
use Botble\Media\Chunks\Receiver\FileReceiver;
use Botble\RealEstate\Concerns\ChunkFile;
use Illuminate\Support\Facades\Validator;

class ChunkController extends BaseController
{
    use ChunkFile;

    public function __construct()
    {
        BaseHelper::maximumExecutionTimeAndMemoryLimit();
    }

    protected function uploadFile(FileReceiver $receiver, string $sessionId, string $basePath = null)
    {
        if ($receiver->isUploaded() === false) {
            throw new UploadMissingFileException();
        }

        $save = $receiver->receive();

        if (! $save->isFinished()) {
            $handler = $save->handler();

            return $this
                ->httpResponse()
                ->setData([
                    'done' => $handler->getPercentageDone(),
                    'status' => true,
                ]);
        }

        $file = $save->getFile();
        $filePath = sprintf('%s.%s', $sessionId, $file->getClientOriginalExtension());
        $file->move(storage_path($basePath ?: 'app/chunk-import'), $filePath);

        return $this
            ->httpResponse()
            ->setData([
                'file_path' => $filePath,
            ]);
    }

    protected function validator(array $data, array $rules)
    {
        $validator = Validator::make($data, $rules);

        $failed = [];

        foreach ($validator->errors()->toArray() as $index => $errors) {
            $failed[] = [
                'row' => $index,
                'errors' => $errors,
            ];
        }

        return $failed;
    }
}
